<?php
// index.php - versi PHP dari index.html
// Sesuaikan variabel berikut bila perlu:
$siteTitle = "Lintar Jali";
$baseUrl = "https://lintarjali.my.id"; // gunakan "" atau "/" bila file ada di root yang sama
$whatsappNumber = "6281249611312";
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<title><?php echo htmlspecialchars($siteTitle, ENT_QUOTES|ENT_SUBSTITUTE); ?></title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link href="<?php echo $baseUrl; ?>/output.css" rel="stylesheet" />
</head>
<body class="flex">
	<div class="flex flex-col w-full h-full mx-auto ">
		<header 
		 class="flex mb-auto bg-gradient-to-r from-blue-900 via-pink-500 to-blue-500 pb-72"> 
		
			<nav aria-label="Global" class="flex items-center justify-between w-full max-w-6xl px-6 py-6 mx-auto xl:px-0">
				<sup>
					<sub>
						<span style="color:#f1c40f;">
							<strong>
								<span style="font-size:20px;"><?php echo htmlspecialchars(strtoupper($siteTitle)); ?></span>
							</strong>
						</span>
					</sub>
				</sup>
				<p class="max-w-xl text-white " style="text-align: justify;">
					<a href="https://api.whatsapp.com/send?phone=<?php echo rawurlencode($whatsappNumber); ?>">
						<img alt="WA" src="<?php echo $baseUrl; ?>/Gbr-WA.png" style="width: 32px; height: 31px;" />
					</a>
				</p>
			</nav>
		</header>
<!-- ========== END HEADER ========== --><!-- ========== MAIN CONTENT ========== -->

		<main id="content" role="main">
			<div class="px-6 -mt-72">
				<div class="flex flex-col items-center justify-between max-w-6xl px-4 pt-20 mx-auto bg-white shadow bg-img lg:pl-16 rounded-2xl" style="background:#ecd5d5;border:1px solid #bebebe;padding:5px 10px;">
					<div style="width: 310px; height: 400px; overflow: auto; border: 1px solid #ccc; padding: 10px;">
					    <p style="text-align: center;">
							<span style="font-size:18px;">Kalau belum bisa menjadi baik, lebih baik diam. Kalau punya hal yang baik, janganlah diam.</span>
					    </p>
					    
						<p>
							<img alt="" class="mx-auto ml-auto sm:max-w-xs sm:w-1/5" src="<?php echo $baseUrl; ?>/lindawisuda1.png" style="width: 280px; height: 414px;" /> 
							<img alt="" class="mx-auto ml-auto sm:max-w-xs sm:w-1/5" src="<?php echo $baseUrl; ?>/lindawisuda2.png" style="width: 280px; height: 414px;" /> 
							<img alt="" class="mx-auto ml-auto sm:max-w-xs sm:w-1/5" src="<?php echo $baseUrl; ?>/lindawisuda3.jpg" style="width: 280px; height: 414px;" />
							<div class="text-center">
						        <span style="color:#0a0a0a;"><span style="font-size:12px;">Map/Lokasi</span></span>
                                <iframe src="https://www.google.com/maps?q=-8.155989,113.720357&hl=id&z=15&output=embed" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe>
                            </div> 
						</p>
					</div>
					<div class="text-center">
						<p class="max-w-xl mx-auto mb-10 text-lg">
							<sup>
							    <a text-decoration: none !important;">.</a>
								<a href="https://kosjemberindah.lintarjali.my.id/">
									<img alt="Kos Indah Lestari" src="<?php echo $baseUrl; ?>/imgkosindah.png" style="width: 305px; height: 54px;" />
								</a>
							</sup>
							<a href="https://play.google.com/store/apps/developer?id=Lintar+Jali">
								<img alt="Google Play" src="<?php echo $baseUrl; ?>/imggplay.png" style="width: 305px; height: 54px;" />
							</a>
							<a style="font-family: Arial !important; font-size: 16px !important; color: #1e73be !important; text-decoration: none !important;">
								Powered by Jali
							</a>
						</p>
					</div>
				</div>
			</div>
		</main>
	</div>

	<script src="<?php echo $baseUrl; ?>/preline.js"></script>
</body>
</html>
